/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: ProfibusDL_error.h 50833 2015-01-15 12:54:37Z mark $

Description:
  Profibus DL task error codes
**************************************************************************************/
#ifndef __PROFIBUS_DL_ERROR_H
#define __PROFIBUS_DL_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS DL Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_PROFIBUS_DL_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_PROFIBUS_DL_COMMAND_INVALID ((TLR_RESULT)0xC0060001L)

//
// MessageId: TLR_E_PROFIBUS_DL_XC_INVALID
//
// MessageText:
//
//  The assigned XC-Data Link Layer is not installed or has a pending error.
//
#define TLR_E_PROFIBUS_DL_XC_INVALID     ((TLR_RESULT)0xC0060040L)

//
// MessageId: TLR_E_PROFIBUS_DL_BAUDRATE_INVALID
//
// MessageText:
//
//  The specified baudrate option is not supported and is out of range.
//
#define TLR_E_PROFIBUS_DL_BAUDRATE_INVALID ((TLR_RESULT)0xC0060041L)

//
// MessageId: TLR_E_PROFIBUS_DL_GAP_UPDATE_INVALID
//
// MessageText:
//
//  The specified GAP update factor option is not supported and is out of range 1-100.
//
#define TLR_E_PROFIBUS_DL_GAP_UPDATE_INVALID ((TLR_RESULT)0xC0060042L)

//
// MessageId: TLR_E_PROFIBUS_DL_DL_ADDR_INVALID
//
// MessageText:
//
//  The specified local profibus address option is not supported and is out of range 0-125.
//
#define TLR_E_PROFIBUS_DL_DL_ADDR_INVALID ((TLR_RESULT)0xC0060043L)

//
// MessageId: TLR_E_PROFIBUS_DL_RETRY_LIMIT
//
// MessageText:
//
//  The specified retry limit option is not supported and is zero.
//
#define TLR_E_PROFIBUS_DL_RETRY_LIMIT    ((TLR_RESULT)0xC0060044L)

//
// MessageId: TLR_E_PROFIBUS_DL_HSA_INVALID
//
// MessageText:
//
//  The specified highest station address option is not supported and is out of range 0-126.
//
#define TLR_E_PROFIBUS_DL_HSA_INVALID    ((TLR_RESULT)0xC0060045L)

//
// MessageId: TLR_E_PROFIBUS_DL_NO_BUS_PARAMETER_SET
//
// MessageText:
//
//  The service can not be executed, there are no bus parameter specified yet.
//
#define TLR_E_PROFIBUS_DL_NO_BUS_PARAMETER_SET ((TLR_RESULT)0xC0060046L)

//
// MessageId: TLR_E_PROFIBUS_DL_DLE_NOT_RESPONDING
//
// MessageText:
//
//  The service has detected a timeout at the connected XC-Data Link Layer entity.
//
#define TLR_E_PROFIBUS_DL_DLE_NOT_RESPONDING ((TLR_RESULT)0xC0060047L)

//
// MessageId: TLR_E_PROFIBUS_DL_NO_DL_RESOURCE
//
// MessageText:
//
//  There are no further resource blocks available to execute the service within the connected XC-Data Link Layer entity.
//
#define TLR_E_PROFIBUS_DL_NO_DL_RESOURCE ((TLR_RESULT)0xC0060048L)

//
// MessageId: TLR_E_PROFIBUS_DL_FATAL_DL_RESOURCE
//
// MessageText:
//
//  There are no further resource blocks available to execute the service within the connected XC-Data Link Layer entity.
//
#define TLR_E_PROFIBUS_DL_FATAL_DL_RESOURCE ((TLR_RESULT)0xC0060049L)

//
// MessageId: TLR_E_PROFIBUS_DL_STOPPED
//
// MessageText:
//
//  Profibus is stopped command can not be handled.
//
#define TLR_E_PROFIBUS_DL_STOPPED        ((TLR_RESULT)0xC0060050L)

//
// MessageId: TLR_E_PROFIBUS_DL_PENDING_PACKET
//
// MessageText:
//
//  Previous pending packet is returned. It could not be handled. 
//
#define TLR_E_PROFIBUS_DL_PENDING_PACKET ((TLR_RESULT)0xC0060051L)

//
// MessageId: TLR_E_PROFIBUS_DL_SLAVE_MODE
//
// MessageText:
//
//  Command could not be executed, DL-task is running at slave mode.
//
#define TLR_E_PROFIBUS_DL_SLAVE_MODE     ((TLR_RESULT)0xC0060052L)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_UE
//
// MessageText:
//
//  The remote station the service has been sent to indicates a User Error as service acknowlegdement.
//
#define TLR_E_PROFIBUS_DL_ACK_UE         ((TLR_RESULT)0xC0060080L)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_RR
//
// MessageText:
//
//  The remote station the service has been sent to indicates a Resource Error as service acknowlegdement.
//
#define TLR_E_PROFIBUS_DL_ACK_RR         ((TLR_RESULT)0xC0060081L)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_RS
//
// MessageText:
//
//  The remote station the service has been sent to indicates a Service Access Point Error as service acknowlegdement.
//
#define TLR_E_PROFIBUS_DL_ACK_RS         ((TLR_RESULT)0xC0060082L)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_NR
//
// MessageText:
//
//  The remote station the service has been sent to confirms its positive reception but has no data to confirm.
//
#define TLR_E_PROFIBUS_DL_ACK_NR         ((TLR_RESULT)0xC0060083L)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_RDH
//
// MessageText:
//
//  The remote station the service has been sent to, confirms its reception negatively but has returned high priority data in the response.
//
#define TLR_E_PROFIBUS_DL_ACK_RDH        ((TLR_RESULT)0xC0060084L)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_RDL
//
// MessageText:
//
//  The remote station the service has been sent to, confirms its reception negatively but has returned low priority data in the response.
//
#define TLR_E_PROFIBUS_DL_ACK_RDL        ((TLR_RESULT)0xC0060085L)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_DH
//
// MessageText:
//
//  The remote station the service has been sent to, confirms its reception positively and has returned high priority data in the response.
//
#define TLR_E_PROFIBUS_DL_ACK_DH         ((TLR_RESULT)0xC0060086L)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_DL
//
// MessageText:
//
//  The remote station the service has been sent to, confirms its reception positively and has returned low priority data in the response.
//
#define TLR_E_PROFIBUS_DL_ACK_DL         ((TLR_RESULT)0xC0060087L)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_NA
//
// MessageText:
//
//  The remote station the service has been sent to shows no or no plausible reaction at all.
//
#define TLR_E_PROFIBUS_DL_ACK_NA         ((TLR_RESULT)0xC0060088L)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_UNKNOWN
//
// MessageText:
//
//  The remote station the service has been sent has returned an unknown acknowledgement code.
//
#define TLR_E_PROFIBUS_DL_ACK_UNKNOWN    ((TLR_RESULT)0xC0060089L)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_LS
//
// MessageText:
//
//  The requested service is not activated within the local SAP configuration.
//
#define TLR_E_PROFIBUS_DL_ACK_LS         ((TLR_RESULT)0xC006008AL)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_LR
//
// MessageText:
//
//  The local resources needed to execute the requested service are not available or not sufficient.
//
#define TLR_E_PROFIBUS_DL_ACK_LR         ((TLR_RESULT)0xC006008BL)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_DS
//
// MessageText:
//
//  The local data link layer is not in the logical token ring or disconnected from the network.
//
#define TLR_E_PROFIBUS_DL_ACK_DS         ((TLR_RESULT)0xC006008CL)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_IV
//
// MessageText:
//
//  Invalid parameter detected in the requested service.
//
#define TLR_E_PROFIBUS_DL_ACK_IV         ((TLR_RESULT)0xC006008DL)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_NO
//
// MessageText:
//
//  The local SAP is not activated because it has been activated already or resources are not sufficient.
//
#define TLR_E_PROFIBUS_DL_ACK_NO         ((TLR_RESULT)0xC006008EL)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_NO_SET
//
// MessageText:
//
//  The variable to be set does not exist.
//
#define TLR_E_PROFIBUS_DL_ACK_NO_SET     ((TLR_RESULT)0xC006008FL)

//
// MessageId: TLR_E_PROFIBUS_DL_ACK_RE
//
// MessageText:
//
//  Format error of the telegram.
//
#define TLR_E_PROFIBUS_DL_ACK_RE         ((TLR_RESULT)0xC0060090L)

//
// MessageId: TLR_E_PROFIBUS_DL_TSET_INVALID
//
// MessageText:
//
//  The specified parameter TSET is out of range 1-255.
//
#define TLR_E_PROFIBUS_DL_TSET_INVALID   ((TLR_RESULT)0xC0060091L)




#endif  //__PROFIBUS_DL_ERROR_H

